/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.binary;

import cds.savot.binary.Base64;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class Base64OutputStream
extends FilterOutputStream {
    private static int defaultBufferSize = 8192;
    private int group = 0;
    private int bytecounter = 0;
    private int linecounter = 0;

    public Base64OutputStream(OutputStream stream) {
        this(stream, defaultBufferSize);
    }

    public Base64OutputStream(OutputStream stream, int bufferSize) {
        super(new BufferedOutputStream(stream, Base64OutputStream.encodedDataSize(bufferSize)));
    }

    static int encodedDataSize(int nbDataToEncode) {
        if (nbDataToEncode <= 0) {
            return 0;
        }
        int encodedSize = nbDataToEncode / 3;
        if (nbDataToEncode % 3 != 0) {
            ++encodedSize;
        }
        return encodedSize *= 4;
    }

    @Override
    public void write(int b) throws IOException {
        this.group |= (b & 0xFF) << 16 - this.bytecounter * 8;
        ++this.bytecounter;
        if (this.bytecounter == 3) {
            this.commit();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException("The given byte buffer is NULL !");
        }
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException("The given byte buffer is NULL !");
        }
        if (off < 0) {
            throw new ArrayIndexOutOfBoundsException("The offset parameter is negative (" + off + ") !");
        }
        if (off >= b.length) {
            throw new ArrayIndexOutOfBoundsException("The offset parameter (" + off + ") is greater than the buffer size (" + b.length + ") !");
        }
        if (len < 0) {
            throw new ArrayIndexOutOfBoundsException("The length parameter is negative (" + len + ") !");
        }
        if (off + len > b.length) {
            throw new ArrayIndexOutOfBoundsException("Impossible to read " + len + " bytes from a byte array whose the size is " + b.length + " from the " + off + "-th item !");
        }
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i]);
        }
    }

    private void commit() throws IOException {
        if (this.bytecounter > 0) {
            if (this.linecounter == 76) {
                this.out.write(Base64.NEW_LINE.getBytes());
                this.linecounter = 0;
            }
            this.linecounter += 4;
            this.out.write(Base64.base64code[this.group >> 18 & 0x3F]);
            this.out.write(Base64.base64code[this.group >> 12 & 0x3F]);
            this.out.write(this.bytecounter < 2 ? 61 : Base64.base64code[this.group >> 6 & 0x3F]);
            this.out.write(this.bytecounter < 3 ? 61 : Base64.base64code[this.group & 0x3F]);
            this.bytecounter = 0;
            this.group = 0;
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.commit();
        this.out.flush();
        this.out.close();
    }
}

